#ifndef _ConstrainedPropertyHelper_h__
#define _ConstrainedPropertyHelper_h__

#include <buildspec.h>

#include <Client/ClientUtils/Network/NetworkInterface.h>

#include <map>

namespace GST
{
namespace ClientUtils
{

class GST_API_EXPORT ConstrainedPropertyLoader
{
public:
	ConstrainedPropertyLoader()
	{
	}

	NetworkPtr getNetwork() const
	{
		return m_network;
	}
	void setNetwork(NetworkPtr val)
	{
		m_network = val;
	}

	/**
	 * Fetches if not fetched before and return Property values for the given
	 * contrained property (it must be either a ConstrainedSimplexPropertyDesc
	 * or a ConstrainedObjectPropertyDesc)
	 */
	ConstrainedTableAttributeValArrayPtr getConstrainedPropertyValues(
		TableConstrainedAttributeDesc *desc);

protected:
	NetworkPtr m_network;
	typedef std::map<std::string, ConstrainedTableAttributeValArrayPtr>
		ValueMap;
	ValueMap m_fetchedValues;

	std::string genKey(TableConstrainedAttributeDesc *cpdesc);
};

} // namespace ClientUtils
} // namespace GST

#endif // _ConstrainedPropertyHelper_h__
